using System;
using System.Data;

namespace gov.va.med.vbecs.BOL
{
	/// <summary>
	/// Summary description for InventoryItem.
	/// </summary>
	public class InventoryItem : BaseBusinessObject
	{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/17/2002</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary></summary>

		#endregion

		private string _invoiceNumber;
		private string _manufacturerName;
		private Common.Inspection _inspection;
		private CannedComment _cannedComment;
		private int _typeID;

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1140"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Valid InventoryItem object</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="303"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Empty constructor
		/// </summary>
		public InventoryItem()
		{
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/17/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1043"> 
		///		<ExpectedInput>Valid string</ExpectedInput>
		///		<ExpectedOutput>Valid string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="316"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Item's invoice #
		/// </summary>
		public string InvoiceNumber
		{
			get
			{
				return _invoiceNumber;
			}
			set
			{
				_invoiceNumber = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/17/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1044"> 
		///		<ExpectedInput>Valid string</ExpectedInput>
		///		<ExpectedOutput>Valid string</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="317"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Name of item's manufacturer
		/// </summary>
		public string ManufacturerName
		{
			get
			{
				return _manufacturerName;
			}
			set
			{
				_manufacturerName = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/17/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1045"> 
		///		<ExpectedInput>Valid Common.Inspection enum</ExpectedInput>
		///		<ExpectedOutput>Valid Common.Inspection enum</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2067"> 
		///		<ExpectedInput>Invalid Common.Inspection enum</ExpectedInput>
		///		<ExpectedOutput>BusinessObjectException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Inspection enum
		/// </summary>
		public Common.Inspection Inspection
		{
			get
			{
				return _inspection;
			}
			set
			{
				if (Enum.IsDefined(typeof(Common.Inspection), value)==false)
				{
					throw new BOL.BusinessObjectException("Undefined inspection type");
				}
				_inspection = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/17/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1046"> 
		///		<ExpectedInput>Valid canned comment object</ExpectedInput>
		///		<ExpectedOutput>Valid canned comment object</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="320"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Item's canned comment
		/// </summary>
		public CannedComment CannedComment
		{
			get
			{
				return _cannedComment;
			}
			set
			{
				_cannedComment = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/17/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1141"> 
		///		<ExpectedInput>Valid int</ExpectedInput>
		///		<ExpectedOutput>Valid int</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="321"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Item's type ID
		/// </summary>
		public int TypeID
		{
			get
			{
				return this._typeID;
			}
			set
			{
				this._typeID = value;
			}
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1142"> 
		///		<ExpectedInput>Valid data row</ExpectedInput>
		///		<ExpectedOutput>Valid data row</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="349"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///  Loads a data row from an object
		/// </summary>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			return dtRow;
		}

		///<Developers>
		///	<Developer>Krzysztof Dobranowski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/14/2003</CreationDate>
		/// <summary>
		/// Loads an object from a data row
		/// </summary>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
		}



	}
}
